<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Carbon\Carbon;

class CertificadoVehiculo extends Model
{
	use SoftDeletes;

    protected $table = 'certificado_vehiculo';
    protected $fillable = ['id_vehiculo','id_tipocertificado','descripcion','fecha_emision','fecha_vencimiento','estado','documento'];
    protected $primaryKey = 'id';

   
    public function vehiculo() {
        return $this->belongsTo(Vehiculo::class,'id_vehiculo');
    }

 
    public function tipocertificado() {
        return $this->belongsTo(Tipocertificado::class,'id_tipocertificado');
    }

    /**
     * Appends
     */
    public function getIsoFechaEmisionAttribute()
    {
        return static::DateFormat($this->fecha_emision);
    }

    public function getIsoFechaVencimientoAttribute()
    {
        return static::DateFormat($this->fecha_vencimiento);
    }

    
    public static function DateFormat($date)
    {
        if(is_null($date)) return '';
        
        $date_carbon = new Carbon($date);
        $iso_month = $date_carbon->isoFormat('MMMM');
        return "{$date_carbon->day} de {$iso_month} del {$date_carbon->year}";
    }
   
}
