<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CertificadoChofer extends Model
{
	use SoftDeletes;

    protected $table = 'certificado_chofer';
    protected $fillable = ['id_chofer','id_tipocertificado','descripcion','fecha_emision','fecha_vencimiento','estado','documento'];
    protected $primaryKey = 'id';

   
    public function chofer() {
        return $this->belongsTo(Chofer::class,'id_chofer');
    }

 
    public function tipocertificado() {
        return $this->belongsTo(Tipocertificado::class,'id_tipocertificado');
    }

   
}
